<?php
require '../config.php';
session_start();

if (!isset($_SESSION['eleve_id'])) {
    header('Location: connexion_eleve.php');
    exit;
}

// Récupérer le professeur_id à partir de la session ou autre logique
$professeur_id = $_SESSION['professeur_id'] ?? 1; // Par exemple, récupérer depuis la session

$videos_par_page = 6;
$page_courante = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page_courante - 1) * $videos_par_page;

$stmt = $pdo->prepare("SELECT * FROM videos WHERE professeur_id = :professeur_id ORDER BY date_ajout DESC LIMIT :limit OFFSET :offset");
$stmt->bindValue(':professeur_id', $professeur_id, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':limit', $videos_par_page, PDO::PARAM_INT);
$stmt->execute();

$videos = $stmt->fetchAll(PDO::FETCH_ASSOC);
$total_videos_stmt = $pdo->prepare("SELECT COUNT(*) FROM videos WHERE professeur_id = :professeur_id");
$total_videos_stmt->bindValue(':professeur_id', $professeur_id, PDO::PARAM_INT);
$total_videos_stmt->execute();
$total_videos = $total_videos_stmt->fetchColumn();
$total_pages = ceil($total_videos / $videos_par_page);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Vidéos</title>
    <link rel="stylesheet" href="../style.css">
    <style>
        .gallery {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }

        .video-item {
            text-align: center;
            border: 1px solid #ccc;
            padding: 10px;
        }

        .video-item iframe {
            width: 100%;
            height: 200px;
            border: none;
        }

        .pagination {
            margin-top: 20px;
            text-align: center;
        }

        .pagination a {
            margin: 0 5px;
            padding: 10px 15px;
            text-decoration: none;
            color: #333;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .pagination a.active {
            background-color: #007bff;
            color: #fff;
            border-color: #007bff;
        }
    </style>
</head>
<body>
    <?php 
    $menu_path = 'menu.php';
    if (file_exists($menu_path)) {
        include $menu_path;
    } else {
        echo "<p>Menu non trouvé. Vérifiez le chemin d'accès.</p>";
    }
    ?>
    <div class="content">
        <h1>Vidéos</h1>
        <div class="gallery">
            <?php foreach ($videos as $video): ?>
                <div class="video-item">
                    <iframe src="https://www.youtube.com/embed/<?php echo explode('v=', $video['url_video'])[1]; ?>" allowfullscreen></iframe>
                    <p><?php echo htmlspecialchars($video['titre']); ?></p>
                    <p><?php echo !empty($video['description']) ? htmlspecialchars($video['description']) : 'Pas de description disponible.'; ?></p>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="pagination">
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <a href="?page=<?php echo $i; ?>" <?php if ($i == $page_courante) echo 'class="active"'; ?>><?php echo $i; ?></a>
            <?php endfor; ?>
        </div>
    </div>
</body>
</html>
