<?php
require 'config.php'; // Assurez-vous que ce chemin est correct

session_start();

// Vrifiez si l'lve est connect
if (!isset($_SESSION['eleve_id'])) {
    header('Location: connexion_eleve.php');
    exit;
}

// Connexion  la base de donnes
try {
    $dsn = 'mysql:host=localhost;dbname=wassitfm_school';
    $pdo = new PDO($dsn, 'username', 'password');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo 'Erreur de connexion  la base de donnes : ' . $e->getMessage();
    exit;
}

// Rcupration des messages pour l'lve
try {
    $stmt = $pdo->prepare("
        SELECT m.id, m.titre, m.contenu, m.date_envoi, p.nom_complet AS professeur
        FROM messages m
        JOIN professeurs p ON m.id_professeur = p.id
        JOIN message_eleve me ON m.id = me.id_message
        WHERE me.id_eleve = ?
        ORDER BY m.date_envoi DESC
    ");
    $stmt->execute([$_SESSION['eleve_id']]);
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Erreur: " . $e->getMessage();
    exit;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Tableau de Bord lve</title>
    <link rel="stylesheet" href="style.css"> <!-- Assurez-vous d'inclure votre fichier CSS ici -->
</head>
<body>
    <?php include 'menu.php'; ?> <!-- Inclure le menu -->

    <div class="content">
        <h1>Vos Messages</h1>

        <?php if (count($messages) > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>Professeur</th>
                        <th>Titre</th>
                        <th>Contenu</th>
                        <th>Date d'Envoi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($messages as $message): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($message['professeur']); ?></td>
                            <td><?php echo htmlspecialchars($message['titre']); ?></td>
                            <td><?php echo htmlspecialchars($message['contenu']); ?></td>
                            <td><?php echo htmlspecialchars($message['date_envoi']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>Aucun message trouv.</p>
        <?php endif; ?>
    </div>
</body>
</html>
