<?php
// Inclure le fichier de configuration pour la connexion à la base de données
require 'config.php';
session_start(); // Démarrer la session

// Vérification de la session pour les professeurs
if (!isset($_SESSION['professeur_id'])) {
    header('Location: connexion.php');
    exit;
}

// Vérifier si la connexion à la base de données est établie
if (!isset($pdo)) {
    die('Erreur de connexion à la base de données.');
}

// Définir le nombre de vidéos par page
$videosParPage = 6;

// Calculer le numéro de la page actuelle
$pageActuelle = isset($_GET['page']) ? (int)$_GET['page'] : 1;

// Calculer l'offset pour la requête
$offset = ($pageActuelle - 1) * $videosParPage;

// Récupérer les vidéos téléchargées par le professeur, ordonnées par date décroissante
$sql = "SELECT * FROM videos WHERE professeur_id = :professeur_id ORDER BY date_ajout DESC LIMIT :offset, :videosParPage";
$stmt = $pdo->prepare($sql);
$stmt->bindValue(':professeur_id', $_SESSION['professeur_id'], PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':videosParPage', $videosParPage, PDO::PARAM_INT);
$stmt->execute();
$videos = $stmt->fetchAll();

// Compter le nombre total de vidéos pour la pagination
$sqlCount = "SELECT COUNT(*) FROM videos WHERE professeur_id = :professeur_id";
$stmtCount = $pdo->prepare($sqlCount);
$stmtCount->execute([':professeur_id' => $_SESSION['professeur_id']]);
$totalVideos = $stmtCount->fetchColumn();
$totalPages = ceil($totalVideos / $videosParPage);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gérer les Vidéos</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .video-gallery {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            justify-content: center;
        }

        .video-card {
            width: 30%;
            border: 1px solid #ccc;
            padding: 10px;
            box-sizing: border-box;
            position: relative;
            background-color: #f9f9f9;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        iframe {
            width: 100%;
            height: 200px;
            border-radius: 5px;
        }

        .delete-button {
            position: absolute;
            top: 10px;
            right: 10px;
            background-color: red;
            color: white;
            border: none;
            padding: 5px 10px;
            cursor: pointer;
            border-radius: 3px;
            font-size: 12px;
        }

        .pagination {
            margin-top: 20px;
            text-align: center;
        }

        .pagination a {
            margin: 0 5px;
            text-decoration: none;
            padding: 5px 10px;
            border: 1px solid #ccc;
            border-radius: 3px;
            background-color: #f0f0f0;
            color: #333;
        }

        .pagination a:hover {
            background-color: #007BFF;
            color: white;
        }
    </style>
</head>
<body>
    <?php include 'menu.php'; ?>
    <div class="container">
        <h1>Gérer les Vidéos</h1>
        <div class="video-gallery">
            <?php foreach ($videos as $video): 
                // Extraction de l'ID de la vidéo YouTube à partir de l'URL
                $urlParts = parse_url($video['url_video']);
                parse_str($urlParts['query'], $queryParams);
                $videoId = $queryParams['v'];
                $youtubeUrl = 'https://www.youtube.com/embed/' . $videoId;
            ?>
                <div class="video-card">
                    <iframe src="<?php echo $youtubeUrl; ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                    <p><?php echo htmlspecialchars($video['titre']); ?></p>
                    <form method="POST" action="sup_videos.php" onsubmit="return confirm('Voulez-vous vraiment supprimer cette vidéo ?');">
                        <input type="hidden" name="video_id" value="<?php echo $video['id']; ?>">
                        <button type="submit" class="delete-button">Supprimer</button>
                    </form>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="pagination">
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <a href="gerer_videos.php?page=<?php echo $i; ?>"><?php echo $i; ?></a>
            <?php endfor; ?>
        </div>
    </div>
</body>
</html>
