<?php
require 'config.php';
session_start();

// Vérifiez si l'utilisateur est connecté
if (!isset($_SESSION['professeur_id'])) {
    header('Location: connexion.php');
    exit;
}

// Récupérez les informations du professeur
$stmt = $pdo->prepare("SELECT * FROM professeurs WHERE id = ?");
$stmt->execute([$_SESSION['professeur_id']]);
$professeur = $stmt->fetch(PDO::FETCH_ASSOC);

// Vérifiez si les données ont été récupérées correctement
if (!$professeur) {
    // Redirige vers la page de connexion si l'utilisateur n'existe pas
    header('Location: connexion.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Tableau de Bord</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            padding: 20px;
            max-width: 800px;
            margin: auto;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            color: #333;
        }
        a {
            display: inline-block;
            margin: 10px 0;
            padding: 10px;
            color: #007bff;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
<?php include 'menu.php' ;?> 
    <div class="container">
        <h1 align="center">Bienvenue, <?php echo htmlspecialchars($professeur['nom_complet']); ?></h1>
    </div>
</body>
</html>
