<?php
require 'config.php';
session_start();

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Récupérez les informations du formulaire
    $email = $_POST['email'];
    $mot_de_passe = $_POST['mot_de_passe'];

    // Préparez la requête pour vérifier les informations de connexion
    $stmt = $pdo->prepare("SELECT * FROM professeurs WHERE email = ?");
    $stmt->execute([$email]);
    $professeur = $stmt->fetch(PDO::FETCH_ASSOC);

    // Vérifiez si l'utilisateur existe et le mot de passe est correct
    if ($professeur && password_verify($mot_de_passe, $professeur['mot_de_passe'])) {
        // Enregistrez l'ID de l'utilisateur dans la session
        $_SESSION['professeur_id'] = $professeur['id'];
        header('Location: dashboard.php');
        exit;
    } else {
        $message = "Email ou mot de passe incorrect.";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Connexion</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        h1 {
            margin-bottom: 20px;
            color: #333;
        }
        form {
            display: flex;
            flex-direction: column;
        }
        label {
            margin-bottom: 5px;
            text-align: left;
        }
        input {
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        button {
            padding: 10px;
            background: #007bff;
            border: none;
            border-radius: 4px;
            color: #fff;
            cursor: pointer;
        }
        button:hover {
            background: #0056b3;
        }
        .message {
            margin-top: 20px;
            color: #ff0000;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Connexion</h1>
        <form method="POST" action="connexion.php">
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" required>
            <label for="mot_de_passe">Mot de passe:</label>
            <input type="password" id="mot_de_passe" name="mot_de_passe" required>
            <button type="submit">Se Connecter</button>
        </form>
        <?php if ($message): ?>
            <div class="message"><?php echo htmlspecialchars($message); ?></div>
        <?php endif; ?>
    </div>
</body>
</html>
