<?php
session_start();

// Connexion à la base de données
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "wassitfm_school";

$conn = new mysqli($servername, $username, $password, $dbname);

// Vérification de la connexion
if ($conn->connect_error) {
    die("Connexion échouée: " . $conn->connect_error);
}

// Vérification si le professeur est connecté et redirection si nécessaire
if (!isset($_SESSION['professeur_id'])) {
    header('Location: connexion.php');
    exit;
}

// Initialisation du message
$message = '';

// Traitement du formulaire si soumis
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Récupération des données du formulaire et nettoyage
    $titre = htmlspecialchars(trim($_POST['titre']));
    $url_video = htmlspecialchars(trim($_POST['url_video']));
    $professeur_id = $_SESSION['professeur_id'];

    // Validation de l'URL
    if (!filter_var($url_video, FILTER_VALIDATE_URL)) {
        $message = "L'URL de la vidéo n'est pas valide.";
    } else {
        // Préparation et exécution de la requête SQL
        $sql = "INSERT INTO videos (professeur_id, titre, url_video) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);

        if ($stmt === false) {
            die("Erreur de préparation de la requête : " . $conn->error);
        }

        $stmt->bind_param("iss", $professeur_id, $titre, $url_video);

        if ($stmt->execute()) {
            $message = "Vidéo ajoutée avec succès !";
        } else {
            $message = "Erreur lors de l'ajout de la vidéo : " . $stmt->error;
        }

        $stmt->close();
    }
}

// Fermeture de la connexion
$conn->close();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Ajouter une Vidéo</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <link rel="stylesheet" href="style.css"> <!-- Lien vers une feuille de style externe -->
    <style>
        /* Styles généraux */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            padding: 0;
        }

        /* Conteneur principal */
        .container {
            width: 100%;
            max-width: 600px;
            margin: 50px auto;
            padding: 30px;
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        /* Titre de la page */
        h1 {
            text-align: center;
            color: #333333;
            margin-bottom: 20px;
        }

        /* Styles du formulaire */
        form {
            display: flex;
            flex-direction: column;
        }

        label {
            margin-bottom: 5px;
            color: #555555;
            font-weight: bold;
        }

        input[type="text"], textarea {
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #cccccc;
            border-radius: 5px;
            font-size: 16px;
            transition: border-color 0.3s;
        }

        input[type="text"]:focus, textarea:focus {
            border-color: #007bff;
            outline: none;
        }

        /* Bouton de soumission */
        button {
            padding: 12px;
            background-color: #007bff;
            color: #ffffff;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        button:hover {
            background-color: #0056b3;
        }

        /* Messages de retour */
        .message {
            text-align: center;
            margin-bottom: 20px;
            padding: 10px;
            border-radius: 5px;
        }

        .success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        /* Lien vers la gestion des vidéos */
        .manage-link {
            text-align: center;
            margin-top: 20px;
        }

        .manage-link a {
            color: #007bff;
            text-decoration: none;
            font-weight: bold;
        }

        .manage-link a:hover {
            text-decoration: underline;
        }

        /* Responsive design */
        @media (max-width: 600px) {
            .container {
                margin: 20px;
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <?php include 'menu.php'; ?>
    <div class="container">
        <h1>Ajouter une Vidéo YouTube</h1>
        <?php if (!empty($message)): ?>
            <div class="message <?php echo strpos($message, 'succès') !== false ? 'success' : 'error'; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        <form method="POST" action="">
            <label for="titre">Titre de la vidéo :</label>
            <input type="text" id="titre" name="titre" required>

            <label for="url_video">URL de la Vidéo YouTube :</label>
            <input type="text" id="url_video" name="url_video" required>

            <button type="submit">Ajouter Vidéo</button>
        </form>
        <div class="manage-link">
            <a href="gerer_videos.php">Gérer les Vidéos</a>
        </div>
    </div>
</body>
</html>
