<?php
require 'config.php';
session_start();

if (!isset($_SESSION['professeur_id'])) {
    header('Location: connexion.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $titre = $_POST['titre'];
    $pdf = $_FILES['pdf']['name'];
    $pdf_tmp = $_FILES['pdf']['tmp_name'];
    $pdf_path = "uploads/" . $pdf;

    // Déplacer le fichier téléchargé
    move_uploaded_file($pdf_tmp, $pdf_path);

    $stmt = $pdo->prepare("INSERT INTO fiches_pdf (titre, pdf, professeur_id) VALUES (?, ?, ?)");
    $stmt->execute([$titre, $pdf, $_SESSION['professeur_id']]);
    echo "PDF ajouté avec succès!";
}

// Récupérer les PDF existants pour affichage et gestion
$professeur_id = $_SESSION['professeur_id'];
$stmt = $pdo->prepare("SELECT * FROM fiches_pdf WHERE professeur_id = ?");
$stmt->execute([$professeur_id]);
$fiches_pdf = $stmt->fetchAll();

if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("SELECT pdf FROM fiches_pdf WHERE id = ?");
    $stmt->execute([$id]);
    $file = $stmt->fetchColumn();

    if ($file) {
        unlink("uploads/" . $file);
        $stmt = $pdo->prepare("DELETE FROM fiches_pdf WHERE id = ?");
        $stmt->execute([$id]);
        header('Location: ajouter_cours.php');
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Ajouter Cours PDF</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            width: 80%;
            margin: auto;
            overflow: hidden;
        }
        h1 {
            text-align: center;
        }
        form {
            background: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: auto;
        }
        form input[type="text"], form input[type="file"] {
            width: calc(100% - 22px);
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        form button {
            background-color: #007bff;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
        }
        form button:hover {
            background-color: #0056b3;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            background: #fff;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f4f4f4;
        }
        a {
            color: #007bff;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <?php include 'menu.php'; ?>
    <div class="container">
        <h1>Ajouter un Cours PDF</h1>
        <form method="POST" action="ajouter_cours.php" enctype="multipart/form-data">
            <label for="titre">Titre:</label>
            <input type="text" name="titre" required>
            <label for="pdf">Choisir le fichier PDF:</label>
            <input type="file" name="pdf" accept=".pdf" required>
            <button type="submit">Ajouter PDF</button>
        </form>

        <h2>Gestion des Cours PDF</h2>
        <table>
            <tr>
                <th>Titre</th>
                <th>PDF</th>
                <th>Actions</th>
            </tr>
            <?php foreach ($fiches_pdf as $fiches): ?>
            <tr>
                <td><?php echo htmlspecialchars($fiches['titre']); ?></td>
                <td><a href="uploads/<?php echo htmlspecialchars($fiches['pdf']); ?>" target="_blank">Voir PDF</a></td>
                <td><a href="ajouter_cours.php?delete=<?php echo $fiches['id']; ?>" onClick="return confirm('Êtes-vous sûr de vouloir supprimer ce PDF ?')">Supprimer</a></td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>
