<?php
require_once 'config.php'; // Assurez-vous que le chemin est correct

// Initialiser les variables
$matieres = [];
$success_message = "";
$error_message = "";

// Préparer la requête pour obtenir les matières
try {
    $stmt = $pdo->prepare("SELECT id, nom_matiere FROM matiere");
    $stmt->execute();
    $matieres = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Erreur: " . $e->getMessage();
    exit;
}

// Traiter le formulaire lorsqu'il est soumis
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nom_complet = $_POST['nom_complet'];
    $email = $_POST['email'];
    $mot_de_passe = password_hash($_POST['mot_de_passe'], PASSWORD_BCRYPT);
    $tel1 = $_POST['tel1'];
    $enseignement = $_POST['enseignement'];
    $matiere_id = $_POST['matiere'];

    // Vérifier si l'email existe déjà
    try {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM professeurs WHERE email = ?");
        $stmt->execute([$email]);
        $count = $stmt->fetchColumn();

        if ($count > 0) {
            $error_message = "Cet email est déjà utilisé. Veuillez en choisir un autre.";
        } else {
            // Insérer les données dans la base de données
            $stmt = $pdo->prepare("INSERT INTO professeurs (nom_complet, email, mot_de_passe, tel1, enseignement, matiere, statut, date_creation, role)
                                   VALUES (?, ?, ?, ?, ?, ?, 'en attente', NOW(), 'professeur')");
            $stmt->execute([$nom_complet, $email, $mot_de_passe, $tel1, $enseignement, $matiere_id]);

            // Définir le message de succès
            $success_message = "Félicitations, vous êtes inscrit sur notre plateforme avec succès. <br> Pour passer à votre espace administrateur, veuillez vous connecter <a href='professeurs/admin/connexion.php'>ici</a>. <br> Pour voir votre site, veuillez visiter <a href='professeurs/index.php'>votre espace</a>.";
        }
    } catch (PDOException $e) {
        echo "Erreur: " . $e->getMessage();
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Inscription Professeur</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            max-width: 400px;
            width: 100%;
        }
        h1 {
            color: #007bff;
            text-align: center;
        }
        form {
            display: flex;
            flex-direction: column;
        }
        label {
            margin: 10px 0 5px;
        }
        input, select {
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        .button {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 4px;
            cursor: pointer;
        }
        .button:hover {
            background-color: #0056b3;
        }
        .message, .error {
            margin: 15px 0;
            text-align: center;
        }
        .message {
            font-weight: bold;
            color: green;
        }
        .error {
            color: red;
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if ($success_message): ?>
            <div class="message">
                <?php echo $success_message; ?>
            </div>
        <?php endif; ?>
        <?php if ($error_message): ?>
            <div class="error">
                <?php echo $error_message; ?>
            </div>
        <?php endif; ?>

        <h1>Inscription Professeur</h1>
        <form action="" method="post">
            <label for="nom_complet">Nom complet</label>
            <input type="text" id="nom_complet" name="nom_complet" required>

            <label for="email">Email</label>
            <input type="email" id="email" name="email" required>

            <label for="mot_de_passe">Mot de passe</label>
            <input type="password" id="mot_de_passe" name="mot_de_passe" required>

            <label for="tel1">Téléphone</label>
            <input type="text" id="tel1" name="tel1" required>

            <label for="enseignement">Enseignement</label>
            <select id="enseignement" name="enseignement" required>
                <option value="secondaire">Secondaire</option>
                <option value="collège">Collège</option>
                <option value="primaire">Primaire</option>
            </select>

            <label for="matiere">Matière</label>
            <select id="matiere" name="matiere" required>
                <?php
                // Afficher les matières dans le menu déroulant
                foreach ($matieres as $matiere) {
                    echo "<option value=\"" . htmlspecialchars($matiere['id']) . "\">" . htmlspecialchars($matiere['nom_matiere']) . "</option>";
                }
                ?>
            </select>

            <input type="submit" class="button" value="S'inscrire">
        </form>
    </div>
</body>
</html>
